/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class TransparentItemRenderHelper {
    private static final RenderType TRANSLUCENT = RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_);

    private TransparentItemRenderHelper() {
    }

    public static void renderItemWithAlpha(ItemStack stack, int x, int y, int alpha) {
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(stack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        renderer.f_115093_ += 50.0f;
        TransparentItemRenderHelper.renderItemModelWithAlpha(stack, x, y, alpha, model, renderer);
        renderer.f_115093_ -= 50.0f;
    }

    public static void renderItemModelWithAlpha(ItemStack stack, int x, int y, int alpha, BakedModel model, ItemRenderer renderer) {
        boolean flatLight;
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)x, (double)y, (double)(100.0f + renderer.f_115093_));
        modelViewStack.m_85837_(8.0, 8.0, 0.0);
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        boolean bl = flatLight = !model.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), TransparentItemRenderHelper.wrapBuffer((MultiBufferSource)buffer, alpha, alpha < 255), 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.m_69482_();
        if (flatLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.m_6299_(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    public record GhostVertexConsumer(VertexConsumer wrapped, int alpha) implements VertexConsumer
    {
        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.wrapped.m_5483_(x, y, z);
        }

        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            return this.wrapped.m_6122_(red, green, blue, alpha * this.alpha / 255);
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this.wrapped.m_7421_(u, v);
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this.wrapped.m_7122_(u, v);
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this.wrapped.m_7120_(u, v);
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.wrapped.m_5601_(x, y, z);
        }

        public void m_5752_() {
            this.wrapped.m_5752_();
        }

        public void m_7404_(int r, int g, int b, int a) {
            this.wrapped.m_7404_(r, g, b, a);
        }

        public void m_141991_() {
            this.wrapped.m_141991_();
        }
    }
}

